<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\CarConfiguratorTrim;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\ColourMap>
 */
class CarConfiguratorTrimFactory extends Factory
{
    protected $model = CarConfiguratorTrim::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->word,
            'short_description' => $this->faker->sentence(),
            'description' => $this->faker->paragraph(),
            'price' => random_int(1, 10000),
            'monthly_price' => random_int(1, 1000),
            'model_id' => random_int(1, 1000),
        ];
    }
}
