<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_makes', function (Blueprint $table) {
            $table->string('slug')->nullable()->after('id')->index('master_make_slug_index');
        });
        Schema::table('vehicle_models', function (Blueprint $table) {
            $table->string('slug')->nullable()->after('id')->index('master_model_slug_index');
        });
        Schema::table('fuel_types', function (Blueprint $table) {
            $table->string('slug')->nullable()->after('id')->index('master_fuel_slug_index');
        });
        Schema::table('drivetrains', function (Blueprint $table) {
            $table->string('slug')->nullable()->after('id')->index('master_drivetrain_slug_index');
        });
        Schema::table('body_styles', function (Blueprint $table) {
            $table->string('slug')->nullable()->after('id')->index('master_body_slug_index');
        });
        Schema::table('transmissions', function (Blueprint $table) {
            $table->string('slug')->nullable()->after('id')->index('master_transmission_slug_index');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_makes', function (Blueprint $table) {
            $table->dropColumn('slug');
        });
        Schema::table('vehicle_models', function (Blueprint $table) {
            $table->dropColumn('slug');
        });
        Schema::table('fuel_types', function (Blueprint $table) {
            $table->dropColumn('slug');
        });
        Schema::table('drivetrains', function (Blueprint $table) {
            $table->dropColumn('slug');
        });
        Schema::table('body_styles', function (Blueprint $table) {
            $table->dropColumn('slug');
        });
        Schema::table('transmissions', function (Blueprint $table) {
            $table->dropColumn('slug');
        });
    }
};
