<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('property_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name')->index();
            $table->string('slug')->index();
            $table->boolean('active')->default(1)->index();
            $table->text('data')->nullable();
            $table->timestamps();
        });

        Schema::create('property_category_fields', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->index();
            $table->string('slug')->index();
            $table->string('name');
            $table->string('type')->index();
            $table->unsignedInteger('order')->index();
            $table->boolean('active')->default(1)->index();
            $table->string('validation')->nullable();
            $table->text('choices')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
        });

        Schema::create('properties', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->index();
            $table->string('slug')->index();
            $table->string('name')->index();
            $table->boolean('active')->default(1)->index();
            $table->text('data')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('property_categories');
        Schema::dropIfExists('property_category_fields');
        Schema::dropIfExists('properties');
    }
};
