<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->decimal('price', 10, 2)->nullable()->change();
            $table->decimal('original_price', 10, 2)->nullable()->change();
            $table->decimal('previous_price', 10, 2)->nullable()->change();
            $table->decimal('rrp_price', 10, 2)->nullable()->change();
        });

        Schema::table('vehicle_finance', function (Blueprint $table) {
            $table->decimal('total_credit_amount', 10, 2)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->decimal('price', 8, 2)->nullable()->change();
            $table->decimal('original_price', 8, 2)->nullable()->change();
            $table->decimal('previous_price', 8, 2)->nullable()->change();
            $table->decimal('rrp_price', 8, 2)->nullable()->change();
        });

        Schema::table('vehicle_finance', function (Blueprint $table) {
            $table->decimal('total_credit_amount', 8, 2)->nullable()->change();
        });
    }
};
