<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('new_cars', function (Blueprint $table) {
            $table->foreignId('test_drive_form_id')->nullable()->index()->after('form_id');
        });

        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->foreignId('test_drive_form_id')->nullable()->index()->after('form_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('new_cars', function (Blueprint $table) {
            $table->dropColumn('test_drive_form_id');
        });

        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->dropColumn('test_drive_form_id');
        });
    }
};
