<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Mtc\MercuryDataModels\Factories\CarConfiguratorSectionFactory;

class CarConfiguratorSection extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'car_configurator_sections';

    protected $fillable = [
        'model_id',
        'name',
        'label',
        'order',
        'custom',
        'active',
        'data',
    ];

    protected $casts = [
        'active' => 'boolean',
        'custom' => 'boolean',
        'data' => 'array',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected static function newFactory()
    {
        return CarConfiguratorSectionFactory::new();
    }

    public function model(): BelongsTo
    {
        return $this->belongsTo(CarConfiguratorModel::class, 'model_id');
    }
}
