<?php

namespace Mtc\MercuryDataModels\Factories;

use App\Models\ReleaseNote;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @template TModel of \App\Models\ReleaseNote
 *
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<TModel>
 */
class ReleaseNoteFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var class-string<TModel>
     */
    protected $model = ReleaseNote::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'title' => $this->faker->sentence(),
            'content' => $this->faker->paragraph(),
            'is_published' => $this->faker->boolean(),
            'published_at' => $this->faker->date(),
        ];
    }
}
