<?php

namespace Mtc\MercuryDataModels\DealBuilder;

use App\ImportConditionRepository;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AddOnCondition extends Model
{
    protected $table = 'deal_builder_add_on_conditions';

    protected $fillable = [
        'add_on_id',
        'field',
        'condition',
        'value',
    ];

    protected $appends = [
        'field_name',
        'condition_name',
        'value_name',
    ];

    public function addOn(): BelongsTo
    {
        return $this->belongsTo(AddOn::class, 'add_on_id');
    }

    public function getFieldNameAttribute(): string
    {
        return __('vehicles.' . $this->field);
    }

    public function getConditionNameAttribute(): string
    {
        return __('labels.conditions.' . $this->condition);
    }

    public function getValueNameAttribute()
    {
        return (new ImportConditionRepository())->getValue($this->field, $this->value);
    }
}
