<?php

namespace Mtc\MercuryDataModels\DealBuilder;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DealAddOn extends Model
{
    protected $fillable = [
        'deal_id',
        'add_on_id',
        'price',
        'payment_term',
    ];

    public function deal(): BelongsTo
    {
        return $this->belongsTo(Deal::class, 'deal_id');
    }

    public function addOn(): BelongsTo
    {
        return $this->belongsTo(AddOn::class, 'add_on_id');
    }
}
