<?php

namespace Mtc\MercuryDataModels\DealBuilder;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\User;

class DealAttachment extends Model
{
    protected $fillable = [
        'deal_id',
        'deal_note_id',
        'deal_message_id',
        'user_id',
        'filename',
        'original_filename',
        'path',
        'mime_type',
        'size',
    ];

    protected $appends = ['url'];

    public function deal(): BelongsTo
    {
        return $this->belongsTo(Deal::class);
    }

    public function note(): BelongsTo
    {
        return $this->belongsTo(DealNote::class, 'deal_note_id');
    }

    public function message(): BelongsTo
    {
        return $this->belongsTo(DealMessage::class, 'deal_message_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function getUrlAttribute(): string
    {
        return Storage::disk('file-storage')->url($this->path);
    }
}
