<?php

namespace Mtc\MercuryDataModels\DealBuilder;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DealFinance extends Model
{
    protected $table = 'deal_finance';

    protected $fillable = [
        'deal_id',
        'provider',
        'type',
        'lender_name',
        'lender_logo',
        'quote_reference',
        'quote_valid_until',
        'apply_url',
        'retailer_apply_url',
        'print_url',
        'credit_check_url',
        'selected',
        'annual_mileage',
        'first_monthly',
        'monthly_payment',
        'final_payment',
        'full_price',
        'deposit',
        'total_amount',
        'total_credit_amount',
        'apr',
        'interest_rate',
        'number_of_months',
        'cash_price',
        'dealer_deposit',
        'customer_deposit',
        'payable_amount',
        'option_to_purchase_fee',
        'documentation_fee',
        'excess_mileage_charge',
        'terms_and_conditions',
        'data',
    ];

    protected $casts = [
        'data' => 'array',
        'quote_valid_until' => 'datetime',
        'selected' => 'boolean',
    ];

    public function deal(): BelongsTo
    {
        return $this->belongsTo(Deal::class, 'deal_id');
    }
}
