<?php

namespace Mtc\MercuryDataModels\DealBuilder\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\DealBuilder\Deal;
use Mtc\MercuryDataModels\Vehicle;
use Ramsey\Uuid\Uuid;

class DealFactory extends Factory
{
    protected $model = Deal::class;

    public function definition(): array
    {
        return [
            'vehicle_id' => Vehicle::factory(),
            'status_id' => 0,
            'reference' => Uuid::uuid4()->toString(),
            'term' => 60,
            'annual_mileage' => 10000,
            'customer_deposit' => 1000,
            'credit_rating' => 'excellent',
            'total_amount' => 25000,
            'deposit_amount' => 1000,
            'payable_amount' => 0,
        ];
    }

    public function submitted(): static
    {
        return $this->state(fn() => [
            'status_id' => 1,
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'email' => $this->faker->email(),
            'contact_number' => $this->faker->phoneNumber(),
        ]);
    }

    public function withContactDetails(): static
    {
        return $this->state(fn() => [
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'email' => $this->faker->email(),
            'contact_number' => $this->faker->phoneNumber(),
        ]);
    }

    public function withPaymentType(string $paymentType): static
    {
        return $this->state(fn() => [
            'payment_type' => $paymentType,
        ]);
    }
}
