<?php

namespace Mtc\MercuryDataModels\DealBuilder\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\DealBuilder\Deal;
use Mtc\MercuryDataModels\DealBuilder\DealPartExchange;

class DealPartExchangeFactory extends Factory
{
    protected $model = DealPartExchange::class;

    public function definition(): array
    {
        return [
            'deal_id' => Deal::factory(),
            'provider' => 'test',
            'registration' => strtoupper($this->faker->bothify('??## ???')),
            'mileage' => $this->faker->numberBetween(10000, 100000),
            'vehicle_type' => 'car',
            'make' => $this->faker->company(),
            'model' => $this->faker->word(),
            'derivative' => $this->faker->words(3, true),
            'fuel_type' => $this->faker->randomElement(['petrol', 'diesel', 'electric', 'hybrid']),
            'engine_size' => $this->faker->numberBetween(1000, 3000),
            'body_type' => $this->faker->randomElement(['hatchback', 'saloon', 'estate', 'suv']),
            'transmission' => $this->faker->randomElement(['manual', 'automatic']),
            'date_of_registration' => $this->faker->dateTimeBetween('-10 years', '-1 year')->format('Y-m-d'),
            'valuation_made_at' => now(),
            'retail_price' => $this->faker->numberBetween(5000, 20000),
            'average_price' => $this->faker->numberBetween(4000, 18000),
            'clean_price' => $this->faker->numberBetween(4500, 19000),
            'below_price' => $this->faker->numberBetween(3500, 17000),
            'outstanding_finance' => 0,
            'cashback_amount' => 0,
        ];
    }

    public function withOutstandingFinance(float $amount): static
    {
        return $this->state(fn() => [
            'outstanding_finance' => $amount,
        ]);
    }

    public function withCashback(float $amount): static
    {
        return $this->state(fn() => [
            'cashback_amount' => $amount,
        ]);
    }

    public function withValuation(float $retailPrice): static
    {
        return $this->state(fn() => [
            'retail_price' => $retailPrice,
            'average_price' => $retailPrice * 0.9,
            'clean_price' => $retailPrice * 0.95,
            'below_price' => $retailPrice * 0.85,
        ]);
    }
}
