<?php

namespace Mtc\MercuryDataModels\DealBuilder\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\DealBuilder\Status;

class StatusFactory extends Factory
{
    protected $model = Status::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->word(),
            'is_initial' => false,
            'is_final' => false,
            'colour' => $this->faker->hexColor(),
        ];
    }

    public function initial(): static
    {
        return $this->state(fn() => [
            'is_initial' => true,
        ]);
    }

    public function final(): static
    {
        return $this->state(fn() => [
            'is_final' => true,
        ]);
    }
}
