<?php

namespace Mtc\MercuryDataModels\DealBuilder;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\MercuryDataModels\DealBuilder\Factories\StatusFactory;

class Status extends Model
{
    use HasFactory;

    protected static function newFactory(): StatusFactory
    {
        return StatusFactory::new();
    }

    protected $table = 'deal_builder_statuses';

    protected $fillable = [
        'name',
        'editable',
        'is_final',
    ];

    public function deals(): HasMany
    {
        return $this->hasMany(Deal::class);
    }
}
