<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class UserDashboardWidget extends Model
{
    use CentralConnection;
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'user_id',
        'section',
        'position',
        'kind',
        'widget',
        'data'
    ];

    protected $casts = [
        'data' => 'array',
    ];

    protected static function boot()
    {
        parent::boot();
        self::addGlobalScope(fn($query) => $query->orderBy('position'));
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class);
    }
}
