<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            if (Schema::hasColumn('vehicles', 'sold_at') === false) {
                $table->timestamp('sold_at')->nullable()->after('deleted_at')->index();
            }
            if (Schema::hasColumn('vehicles', 'reserved_at') === false) {
                $table->timestamp('reserved_at')->nullable()->after('sold_at')->index();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropColumn(['reserved_at', 'sold_at']);
        });
    }
};
