<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('vehicle_makes', 'caravans') === false) {
            Schema::table('vehicle_makes', function (Blueprint $table) {
                $table->boolean('caravans')->default(0)->index();
                $table->boolean('motorhomes')->default(0)->index();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_makes', function (Blueprint $table) {
            $table->dropColumn([
                'caravans',
                'motorhomes',
            ]);
        });
    }
};
