<?php

namespace Mtc\MercuryDataModels\Filters;

use Closure;
use Illuminate\Support\Collection;

class OfferPriceMaxFilter extends OfferPriceMinFilter
{
    public function applyFilter($query, array $selection = [])
    {
        $query->where('price', '<=', $selection);
    }

    public function getResults(Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        return $this->getData($product_filtering, $limit, $selections)
            ->map(fn($range) => [
                'id' => $range,
                'value' => $range,
                'name' => $this->getSelectionName($range),
            ])
            ->values();
    }


    /**
     * Check if $selection (url slug) matches pattern on this filter
     *
     * @param string $selection
     * @return bool
     */
    public function patternMatched(string $selection): bool
    {
        return preg_match('/price-up-to-[0-9]+/', $selection);
    }

    /**
     * Decode $selection url slug to selection value(s)
     *
     * @param string $selection
     * @return string|array
     */
    public function matchSelections(string $selection)
    {
        preg_match('/price-up-to-([0-9]+)/', $selection, $matches);
        return $matches[1];
    }

    /**
     * Text format of the selection name
     *
     * @param $selection
     * @return string
     */
    public function getSelectionName($selection): string
    {
        return 'Price Up To ' . $this->asCurrency($selection);
    }

    /**
     * Create URL slug for $selection value
     *
     * @param $selection
     * @return string
     */
    public function createSlug($selection): string
    {
        return 'price-up-to-' . $selection;
    }

    protected function isRangeMaximum(): bool
    {
        return true;
    }

    public function filterType(): string
    {
        return 'price_max';
    }
}
