<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('go_live_tasks', function (Blueprint $table) {
            $table->id();
            $table->string('tenant_id')->index();
            $table->string('task', 50)->index();
            $table->dateTime('last_triggered_at')->nullable()->index();
            $table->dateTime('completed_at')->nullable()->index();
            $table->dateTime('failed_at')->nullable()->index();
            $table->foreignId('completed_by')->nullable()->index();
            $table->text('details')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('go_live_tasks');
    }
};
