<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('pages', 'franchise_id')) {
            Schema::table('pages', function (Blueprint $table) {
                $table->foreignId('franchise_id')->nullable()->index();
            });
        }
        if (!Schema::hasColumn('menus', 'franchise_id')) {
            Schema::table('menus', function (Blueprint $table) {
                $table->foreignId('franchise_id')->nullable()->index();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pages', function (Blueprint $table) {
            $table->dropColumn('franchise_id');
        });

        Schema::table('menus', function (Blueprint $table) {
            $table->dropColumn('franchise_id');
        });
    }
};
