<?php

namespace Mtc\MercuryDataModels\Services;

use App\Facades\Settings;

class FinanceServiceHelper
{
    public static function getProvider(): ?string
    {
        return (new self())->determineProvider();
    }

    /**
     * Check if there is an enabled finance provider
     *
     * @return bool
     */
    public static function hasEnabledProvider(): bool
    {
        return !empty((new self())->determineProvider());
    }


    /**
     * Determine which provider is set for the client
     *
     * @return string|null
     */
    public function determineProvider(): ?string
    {
        // note that we return the first valid element, so ordering is important
        return collect([
            'codeweavers' => Settings::get('finance-codeweavers-enabled'),
            'ivendi-pv' => Settings::get('finance-ivendi-enabled')
                && Settings::get('vehicle-finance-type') === 'peter-vardy',
            'ivendi' => Settings::get('finance-ivendi-enabled'),
            'evolution' => Settings::get('finance-evolution-enabled'),
        ])
            ->filter()
            ->keys()
            ->first();
    }
}
