<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\Dealership;

class DealershipFactory extends Factory
{
    protected $model = Dealership::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->sentence(),
            'email' => $this->faker->safeEmail(),
            'active' => true,
            'contact_no' => $this->faker->phoneNumber(),
            'address1' => $this->faker->streetAddress(),
            'address2' => $this->faker->streetName(),
            'city' => $this->faker->city(),
            'county' => '',
            'postcode' => $this->faker->postcode(),
            'country' => $this->faker->countryCode(),
            'open_times' => json_encode([]),
            'coordinates' => implode(',', $this->faker->localCoordinates()),
            'contact_form_id' => random_int(0, 10),
        ];
    }
}
