<?php

namespace Mtc\MercuryDataModels\Finance\Config;

use App\Facades\Settings;

class SantanderConfig
{
    public const UAT_BASE_URL = 'https://ficresuktestcert.santanderconsumer.com';
    public const LIVE_BASE_URL = 'https://ficresuk.santanderconsumer.com';
    public const QUOTES_PATH = '/QuotingTool/api/multi';
    public const PRODUCTS_PATH = '/QuotingTool/api/products';

    public function enabled(): bool
    {
        return Settings::get('finance-santander-enabled', false);
    }

    public function username(): string
    {
        return Settings::get('finance-santander-username', '');
    }

    public function password(): string
    {
        return Settings::get('finance-santander-password', '');
    }

    public function dealerCode(): string
    {
        return Settings::get('finance-santander-dealer-code', '');
    }

    public function environment(): string
    {
        return Settings::get('finance-santander-environment', 'uat');
    }

    public function hpProductId(): ?string
    {
        return Settings::get('finance-santander-hp-product-id');
    }

    public function pcpProductId(): ?string
    {
        return Settings::get('finance-santander-pcp-product-id');
    }

    public function baseUrl(): string
    {
        return $this->environment() === 'live'
            ? self::LIVE_BASE_URL
            : self::UAT_BASE_URL;
    }

    public function quotesPath(): string
    {
        return self::QUOTES_PATH;
    }

    public function productsPath(): string
    {
        return self::PRODUCTS_PATH;
    }
}
