<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Contracts\MenuEntry as BaseMenuEntry;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * @param int $id
 * @param int $menu_id
 * @param int|null $parent_id
 * @param int $linked_model_id
 * @param string $linked_model_type
 * @param string $name
 * @param string|null $url
 * @param array|null $data
 * @param array|null $content
 * @param bool $is_enabled
 */
class MenuEntry extends BaseMenuEntry implements Auditable
{
    use \OwenIt\Auditing\Auditable;

    protected static function boot()
    {
        parent::boot();
        self::saving(fn (self $entry) => $entry->checkUrlAndEnabled());
        self::updating(fn (self $entry) => $entry->checkUrlAndEnabled());
    }

    /**
     * Check and adjust url and enabled status
     *
     * @return void
     */
    protected function checkUrlAndEnabled(): void
    {
        // TODO: Do this properly - this shouldn't auto-enable if was disabled manually
        // $this->checkEnabledStatus();
        $this->checkUrl();
    }

    /**
     * Check if the status should be set based on linked model
     *
     * @return void
     */
    protected function checkEnabledStatus(): void
    {
        if (($this->attributes['item_type'] ?? null) === 'page') {
            $this->attributes['is_enabled'] = Page::query()
                ->where('id', $this->attributes['item_id'])
                ->exists();
        }
    }

    /**
     * Set url based on the linked model
     *
     * @return void
     */
    protected function checkUrl(): void
    {
        if (!empty($this->attributes['item_id'])) {
            $this->attributes['url'] = $this->item()->first()?->urlPath();
        }
    }


    /**
     * Define thumbnail sizes to auto-generate for this model
     *
     * @return mixed
     */
    public function getDefaultAllowedMediaSizesAttribute()
    {
        return Config::get('automotive.menu_entry_image_sizes', []);
    }
}
