<?php

namespace Mtc\MercuryDataModels;

use Mtc\ContentManager\Traits\ModelSortAndFilter;

class Audit extends \OwenIt\Auditing\Models\Audit
{
    use ModelSortAndFilter;

    protected $casts = [
        'created_at' => 'datetime:d/m/Y H:i',
    ];

    protected $hidden = [
        'id',
        'user_type',
        'user_id',
        'auditable_type',
        'auditable_id',
        'url',
    ];

    protected $appends = [
        'name'
    ];

    public function getNameAttribute()
    {
        if ($this->auditable_type == 'setting') {
            return $this->auditable?->section . ' ' . $this->auditable?->group . ' ' . $this->auditable?->name;
        }

        return $this->auditable?->name ?? $this->auditable?->title;
    }
}
