<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\DealershipContent;

class DealershipContentFactory extends Factory
{
    protected $model = DealershipContent::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'dealership_id' => random_int(1, 10),
            'parent_id' => random_int(1, 10),
            'global_content_id' => random_int(1, 10),
            'element_id' => random_int(1, 10),
            'name' => $this->faker->word(),
            'content' => json_encode([]),
            'search_content' => random_int(1, 10),
        ];
    }
}
