<?php

namespace Mtc\MercuryDataModels\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\Invoice;
use Mtc\MercuryDataModels\InvoiceStatus;

class InvoiceFactory extends Factory
{
    protected $model = Invoice::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $amount = random_int(50, 15000);
        return [
            'tenant_id' => random_int(1, 100),
            'email' => $this->faker->safeEmail(),
            'status' => collect(InvoiceStatus::cases())->random(1)->first(),
            'due_at' => Carbon::now()->addDays(random_int(-100, 100)),
            'paid_at' => random_int(0, 1) ? null : Carbon::now()->addDays(random_int(-100, 100)),
            'amount' => $amount,
            'amount_paid' => random_int(0, 1) ? $amount : 0,
            'vat_rate' => random_int(0, 10) ? Invoice::REGULAR_VAT : Invoice::NO_VAT,
            'data' => [],
        ];
    }
}
