<?php

namespace Mtc\MercuryDataModels\Finance\Contracts;

use Illuminate\Contracts\Support\Arrayable;
use JetBrains\PhpStorm\ArrayShape;

class FinanceResult implements Arrayable
{
    public readonly float $total_credit_amount;

    public function __construct(
        public readonly string $provider,
        public readonly FinanceType $finance_type,
        public readonly float $monthly_price,
        public readonly int $term,
        public readonly int $number_of_payments,
        public readonly float $total_deposit,
        public readonly float $apr,
        public readonly float $first_payment,
        public readonly float $final_payment,
        public readonly float $interest_rate,
        public readonly string $apply_url,
        public readonly string $product_name,
        public readonly int $annual_mileage,
        public readonly float $cash_price,
        public readonly float $dealer_deposit,
        public readonly float $customer_deposit,
        public readonly float $payable_amount,
        public readonly float $option_to_purchase_fee,
        public readonly float $documentation_fee,
        public readonly array $messages = [],
        public readonly string $terms_and_conditions = '',
        public readonly ?float $excess_mileage_charge = null,
    ) {
        $this->total_credit_amount = $this->cash_price - $this->total_deposit;
    }

    public function toArray(): array
    {
        return [
            'provider' => $this->provider,
            'finance_type' => $this->finance_type,
            'monthly_price' => $this->monthly_price,
            'term' => $this->term,
            'number_of_payments' => $this->number_of_payments,
            'total_deposit' => $this->total_deposit,
            'apr' => $this->apr,
            'first_payment' => $this->first_payment,
            'final_payment' => $this->final_payment,
            'interest_rate' => $this->interest_rate,
            'apply_url' => $this->apply_url,
            'annual_mileage' => $this->annual_mileage,
            'cash_price' => $this->cash_price,
            'dealer_deposit' => $this->dealer_deposit,
            'customer_deposit' => $this->customer_deposit,
            'payable_amount' => $this->payable_amount,
            'option_to_purchase_fee' => $this->option_to_purchase_fee,
            'documentation_fee' => $this->documentation_fee,
            'messages' => $this->messages,
            'total_credit_amount' => $this->total_credit_amount,
            'terms_and_conditions' => $this->terms_and_conditions,
            'excess_mileage_charge' => $this->excess_mileage_charge,
        ];
    }
}
