<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSystemAlertsTable extends Migration
{
    public function up()
    {
        Schema::create('system_alerts', function (Blueprint $table) {
            $table->id();
            $table->string('alert_type');
            $table->timestamp('last_sent_at')->nullable();

            $table->index('last_sent_at');
            $table->index('alert_type');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('system_alerts');
    }
}
