<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('vehicle_offer_content', function (Blueprint $table) {
            $table->foreignId('template_element_id')->nullable()->index()->after('parent_id');
            $table->mediumText('data')->nullable();
            $table->unsignedInteger('order')->default(0)->index();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vehicle_offer_content', function (Blueprint $table) {
            $table->dropColumn([
                'template_element_id',
                'data',
                'order',
            ]);
        });
    }
};
