<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('seo_redirects', function (Blueprint $table) {
            $table->string('from_domain')->nullable();
            $table->string('to_domain')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('seo_redirects', function (Blueprint $table) {
            $table->dropColumn([
                'from_domain',
                'to_domain',
            ]);
        });
    }
};
