<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dealership_franchises', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dealership_id');
            $table->foreignId('franchise_id');
            $table->timestamps();
            $table->unique(['dealership_id', 'franchise_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dealership_franchises');
    }
};
