<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('export_maps', function (Blueprint $table) {
            $table->integer('template_id')->nullable();
            $table->json('mapping_rules')->nullable()->after('columns');
            $table->json('headers')->nullable()->after('columns');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('export_maps', function (Blueprint $table) {
            $table->dropColumn([
                'template_id',
                'mapping_rules',
                'headers',
            ]);
        });
    }
};
