<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\VehicleAutoTraderData;
use Mtc\MercuryDataModels\VehicleFinance;

class VehicleAutoTraderDataFactory extends Factory
{
    protected $model = VehicleAutoTraderData::class;

    protected array $performanceRatings = [
        'NONE',
        'LOW',
        'BELOW AVERAGE',
        'ABOVE AVERAGE',
        'EXCELLENT'
    ];

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'vehicle_id' => random_int(1, 100),
            'valuation' => random_int(100, 100000),
            'price_point' => array_rand(['Excellent', 'Great', 'Good', 'Fair', 'Poor']),
            'price_position' => random_int(0, 200),
            'search_results_7d' => random_int(0, 10000),
            'ad_views' => random_int(0, 1000),
            'ad_views_7d' => random_int(0, 10000),
            'performance_rating' => $this->faker->randomElement($this->performanceRatings),
            'lead_count_rating' => $this->faker->randomElement(['HIGH', 'MEDIUM', 'LOW', null]),
        ];
    }
}
