<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->index('updated_at');
        });
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->index('updated_at');
        });
        Schema::table('new_cars', function (Blueprint $table) {
            $table->index('updated_at');
        });
        Schema::table('pages', function (Blueprint $table) {
            $table->index('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropIndex(['updated_at']);
        });
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->dropIndex(['updated_at']);
        });
        Schema::table('new_cars', function (Blueprint $table) {
            $table->dropIndex(['updated_at']);
        });
        Schema::table('pages', function (Blueprint $table) {
            $table->dropIndex(['updated_at']);
        });
    }
};
