<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicle_subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('customer_id')->constrained('customers')->cascadeOnDelete();
            $table->foreignId('vehicle_id')->constrained('vehicles')->cascadeOnDelete();
            $table->string('event_type', 50);
            $table->string('unsubscribe_token', 64)->unique();
            $table->timestamp('last_notified_at')->nullable();
            $table->timestamps();

            $table->unique(['customer_id', 'vehicle_id', 'event_type'], 'unique_subscription');
            $table->index(['vehicle_id', 'event_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vehicle_subscriptions');
    }
};
