<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\BillableFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class Billable extends Model
{
    use HasFactory;
    use CentralConnection;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'billables';

    /**
     * Mass assign attributes
     *
     * @var array
     */
    protected $fillable = [
        'type', // BillingType
        'code',
        'name',
        'description',
        'active',
        'price',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'active' => 'boolean',
    ];

    /**
     * Model Factory
     *
     * @return BillableFactory
     */
    protected static function newFactory()
    {
        return BillableFactory::new();
    }

    /**
     * Relationship with tenant billable records
     *
     * @return HasMany
     */
    public function tenantBillables(): HasMany
    {
        return $this->hasMany(TenantBillable::class, 'billable_id');
    }
}
