<?php

namespace Mtc\MercuryDataModels\Leasing;

class KeyloopFinanceRequest
{
    /**
     * @param int $contract_length_months
     * @param int $deposit_months
     * @param float $item_price_ex_vat_ex_vrt
     * @param float $vrt
     * @param float $discount_percentage_as_decimal
     * @param float|null $vat_as_decimal
     * @param float $residual_value_ex_vat
     * @param float $delivery_price
     * @param float $bonus_value
     * @param float $electric_grant
     */
    public function __construct(
        public int $contract_length_months = 0,
        public int $deposit_months = 0,
        public float $item_price_ex_vat_ex_vrt = 0,
        public float $vrt = 0,
        public float $discount_percentage_as_decimal = 0,
        public ?float $vat_as_decimal = null,
        public float $residual_value_ex_vat = 0,
        public float $delivery_price = 0,
        public float $bonus_value = 0,
        public float $electric_grant = 0,
    ) {
        //
    }
}
