<?php

namespace Mtc\MercuryDataModels\Tools;

class UiUrlGenerator
{
    public static function make(string $path, array $queryParams = [], bool $absolute = true): string
    {
        $prefix = $absolute ? config('app.frontend_url') : '';
        $queryString = !empty($queryParams) ? '?' . http_build_query($queryParams) : '';
        return $prefix . '/' . ltrim($path, '/') . $queryString;
    }
}
