---
description: "Extract Figma component directly to Laravel Twig + LESS"
allowed_tools: ["Read", "Edit", "Write", "Bash", "mcp__figma-desktop__*", "mcp__playwright__*", "TodoWrite"]
---

# Figma Component Extraction

Extract a Figma component directly to production-ready Laravel Twig template and LESS stylesheet.

## Usage
```
/mtc-extract <figma-component-url>
```

## Requirements
- Component-specific Figma URL with node-id parameter (e.g., `?node-id=26-215`)
- Design system must be rebranded first (see Prerequisites Check below)
- Figma and Playwright MCP server access

## Prerequisites Check

**Design System Validation:**
```bash
grep "DESIGN SYSTEM STATUS: figma-rebranded" sites/default/css/variables.less
```

❌ **If not rebranded:** Use `/mtc-rebrand <full-page-figma-url>` first

## Process

This command executes the unified workflow defined in `.frontend/workflows-yaml/figma-extract.yaml`.

**Steps:**
1. **Verify design system** - Check rebrand status
2. **Parse Figma URL** - Extract node ID and component name from Figma metadata
3. **Classify component** - Determine if page_block, element, or partial
4. **Capture reference** - Screenshot from Figma at multiple breakpoints
5. **Create Twig template** - Generate Laravel template with dummy data support
6. **Create LESS stylesheet** - Extract styles using design system tokens
7. **Update build system** - Add LESS import to includes.less
8. **Add to example page** - Auto-add component to example_blocks.twig
9. **Build and test** - Run npm build
10. **Playwright validation** - Validate at localhost/example-blocks at ALL breakpoints (see below)

**Output Locations:**

| Component Type | Twig Template | LESS Stylesheet |
|---------------|---------------|-----------------|
| Page Section | `sites/default/templates/includes/page_blocks/{name}.twig` | `sites/default/css/blocks/{name}.less` |
| Element | `sites/default/templates/includes/elements/{name}.twig` | `sites/default/css/elements/{name}.less` |
| Partial | `sites/default/templates/includes/partials/{name}.twig` | `sites/default/css/elements/{name}.less` |

**Additional Output:**
- `.frontend/figma-selections/{component-name}-figma.png` - Reference screenshot

**Component Naming:**
- Automatically extracts semantic name from Figma layer name
- Example: "3 Step Approach Section" → `three-step-approach-section`
- Fallback: If name unavailable, uses `component-{node-id}`

## Critical Rules

- ❌ NO `asset()` function (use `/sites/default/{{ variable }}` for images)
- ✅ Use `.button` class (no custom button CSS)
- ✅ Use `.headingStyle()` mixin for headings
- ✅ Use `<div>` for `|raw` content, NEVER `<p>` (TinyMCE compatibility)
- ✅ 85%+ design system compliance required

## Quality Gates

- Visual Accuracy: >= 98%
- Console Errors: 0
- Responsive: All breakpoints passing
- Accessibility: WCAG AA compliant

## Playwright Validation (MANDATORY - DO NOT SKIP)

You MUST test the component at EACH breakpoint before marking extraction complete. This is non-negotiable.

**Required Breakpoint Tests:**

1. **Mobile (375px)**
   - `mcp__playwright__browser_resize` width: 375, height: 800
   - Navigate to component, take screenshot
   - Verify layout is correct, no overflow, text readable

2. **Tablet (768px)**
   - `mcp__playwright__browser_resize` width: 768, height: 1024
   - Navigate to component, take screenshot
   - Verify layout adapts correctly (e.g., 2-column grid)

3. **Desktop (1024px)**
   - `mcp__playwright__browser_resize` width: 1024, height: 768
   - Navigate to component, take screenshot
   - Verify full layout displays correctly

4. **Wide (1440px)**
   - `mcp__playwright__browser_resize` width: 1440, height: 900
   - Navigate to component, take screenshot
   - Verify component doesn't stretch awkwardly

**If ANY breakpoint fails:**
- Fix the LESS stylesheet
- Re-run npm build
- Re-test ALL breakpoints

**DO NOT mark the extraction as complete until all 4 breakpoints pass.**

## Completion

Upon successful extraction:

**Created Files:**
- `sites/default/templates/includes/{type}/{component}.twig` - Laravel template
- `sites/default/css/{type}/{component}.less` - Component stylesheet
- `.frontend/figma-selections/{component}-figma.png` - Reference screenshot

**Updated Files:**
- `sites/default/includes.less` - Added LESS import
- `sites/default/templates/pages/example_blocks.twig` - Added component preview

**Preview:**
- View at: `http://localhost/example-blocks`

**Usage Example:**
```twig
{% include 'includes/page_blocks/component-name.twig' with {
    'title': 'Your Title',
    'content': 'Your content here'
} %}
```

## Reference
- **Workflow Definition**: `.frontend/workflows-yaml/figma-extract.yaml`
- **Twig Patterns**: `.frontend/workflows/twig-template-patterns.md`
- **Documentation**: See `.claude/commands/README.md` for detailed information
