<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Core\RateLimit;

class CleanupRateLimits extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rate-limits:cleanup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean up old rate limit records older than 14 days';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Cleaning up old rate limit records...');
        
        RateLimit::cleanup();
        
        $this->info('Rate limit cleanup completed successfully.');
        
        return 0;
    }
}
