<?php

namespace App\Console\Commands;

use App\Src\Encryption;
use Exception;
use Illuminate\Console\Command;

class DecryptDbFields extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'decryption:run';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Decrypts all fields marked as "encrypted" in the database.';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        foreach (Encryption::$modelsWithEncryption as $model) {
            try {
                Encryption::decrypt($model);
                $this->info("Decrypted fields for model: {$model}");
            } catch (Exception $e) {
                $this->error("Decryption failed for model {$model}: " . $e->getMessage());
            }
        }

        return 0;
    }
}
