<?php

namespace App\Console\Commands;

use App\Src\Encryption;
use Exception;
use Illuminate\Console\Command;

class EncryptDbFields extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'encryption:run';
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Encrypts all fields marked as "encrypted" in the database.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle(): int
    {
        foreach (Encryption::$modelsWithEncryption as $model) {
            try {
                Encryption::encrypt($model);
            } catch (Exception) {

            }
        }
        return 0;
    }
}