<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Plugins\DeliveryCouriers\Classes\Courier;
use Mtc\Shop\DeliveryServicesOption;

class SyncDeliveryServiceOptionCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sync:delivery-options';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync delivery options from delivery api';


    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        collect(Courier::getCourierServiceList())
            ->each(function ($courier) {
                collect($courier->services)
                    ->each(function ($service) {

                        DeliveryServicesOption::query()
                            ->create([
                                'service_id' => DeliveryServicesOption::DELIVERY_API,
                                'name' => $service->name,
                                'code' => $service->id,
                            ]);
                    });
            });
    }
}
