<?php

namespace App\Events;

use Mtc\Modules\Members\Models\Member;

/**
 * Class MemberUpdatedEvent
 *
 * Event triggered when a member is updated
 *
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk
 * @version 17.09.2024
 */
class MemberUpdatedEvent
{

    /**
     * @var Member $member
     */
    protected Member $member;

    /**
     * @var Member $oldMember
     */
    protected Member $oldMember;

    /**
     * @return Member
     */
    public function getMember(): Member
    {
        return $this->member;
    }

    /**
     * @return Member
     */
    public function getOldMember(): Member
    {
        return $this->oldMember;
    }

    /**
     * @param Member $oldMember
     * @param Member $member
     */
    public function __construct(Member $oldMember, Member $member)
    {
        $this->member = $member;
        $this->oldMember = $oldMember;
    }
}
