<?php

namespace App\Events;


use Mtc\Shop\Order;

/**
 * Class OrderCreatedEvent
 *
 * Event triggered when an order is created
 *
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk
 * @version 17.09.2024
 */
class OrderCreatedEvent
{

    /**
     * @var Order $order
     */
    protected Order $order;

    /**
     * @var $basket
     */
    protected $basket;

    /**
     * @return Order
     */
    public function getOrder(): Order
    {
        return $this->order;
    }

    /**
     * @return mixed
     */
    public function getBasket()
    {
        return $this->basket;
    }

    /**
     * @param Order $order
     * @param $basket
     */
    public function __construct(Order $order, $basket)
    {
        $this->order = $order;
        $this->basket = $basket;
    }
}
