<?php

namespace App\Providers;

use Illuminate\Support\Facades\App;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

/**
 * Class RouteServiceProvider
 *
 * @package App\Providers
 */
class RouteServiceProvider extends ServiceProvider
{
    /**
     * Define the routes for the application.
     *
     * @return void
     */
    public function map()
    {
        $this->mapApiRoutes();
        $this->mapWebRoutes();
        $this->mapReverbRoutes();
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {
        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {
        Route::prefix('api')
             ->middleware('api')
             ->group(dirname(__DIR__, 2) . '/routes/api.php');
    }

    /**
     * @description Add reverb routes used to implement sockets
     * @returns void
     * @author Nithika Senaweera
     * */
    protected function mapReverbRoutes() : void
    {
        Route::prefix('channels')
             ->middleware('api')
             ->group(dirname(__DIR__, 2) . '/routes/channels.php');
    }

}
