/**
 * Function run when history panel gets loaded
 * Contains all the native js events
 * @author Rihards Siliņš
 * @version 1 25/11/2015
 */
function historyInit(dom_scope) {
    if ( typeof dom_scope === 'undefined' || dom_scope === false || dom_scope === "" || dom_scope === 0 ) {
        dom_scope = '#historyContainer';
    }

    $(dom_scope).find('a.preview').on("click", function(event){
        cmsPreventDefault(event);
        pagePreviewBtn($(this).data("page-id"), $(this).data("page-url"));
        return false;
    });

    $(dom_scope).find('a.delete').on("click", function(event){
        cmsPreventDefault(event);
        deleteHistoryItem($(this));
        return false;
    });

    $(dom_scope).find('a.lockVersion').on("click", function(event){
        cmsPreventDefault(event);
        lockVersion($(this));
        return false;
    });

    $(dom_scope).find('a.displayVersionInformationBtn').on("click", function(event){
        cmsPreventDefault(event);
        displayVersionInformationBtn($(this));
        return false;
    });

    $(dom_scope).find('a.markReviewed').on("click", function(event){
        cmsPreventDefault(event);
        markReviewedBtn($(this));
        return false;
    });

    $(dom_scope).find('a.viewVersion').on("click", function(event){
        cmsPreventDefault(event);
        viewVersionBtn($(this));
        return false;
    });
    listingInitCustom(dom_scope);
}