<?php
/**
 * Content Manager Panel Dashboard
 * @author Rihards Siliņš
 * @version 3 10/11/2016
 */
$cms_root_path = "../../../";
require_once($cms_root_path."includes/compatibility_includer.php");

?>

<div class="pageActionBtns  clearfix">

    <?php
    if ($_SESSION['content_manager']['is_mtcadmin']) {
        ?>
        <button class="btn newPageBtn">NEW PAGE</button>
        <fieldset class="topBarButtonFieldset pageFieldset">
            <a href="#" class="paste-page-btn" title="Paste page(s)">
                <i class="fa fa-paste"></i>
            </a>
        </fieldset>
        <?php
    }
    ?>

    <div class="controlPanelLoaderContainerInActionBtns">
        <div id="controlPanelLoader" class="controlPanelLoader">
            <span class="spinnerContainer">
              <span class="spinner"></span>
            </span>
            <span class="loaderMessage">loading&hellip;</span>
        </div>
    </div>
</div>

<div class="mainForm">

    <p><?=_('Welcome to the mtc. cms2+ content manager!')?></p>
    <a href="#" class="hidden-preview-page-btn" style="display:none">&nbsp;</a>

    <?php

    if (defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING == true) {
        $lister = Listing::newInstance()
            ->onlyPublished(false)
            ->onlyDefaultPages(false)
            ->setFilter([
                " `pages`.`type` = 'history' ",
                " `pages`.`review_status` = 1 "
            ])
            ->setOrder([
                " `pages`.`updated` DESC "
            ])
            ->run();

        $lister->getListing();

        if (!empty($lister->list)) {
            ?>
            <fieldset id="versions_pending_review" class="row">
                <h3>
                    <a class="show dashboardFieldsetToggle el">
                        Versions Pending Review
                    <i class="fa fa-caret-down dashboardFieldsetToggleArrow"></i>
                    </a>
                </h3>
                <div class="dashboardSection">
                    <table class="manage-items pageVersions">
                        <tr>
                            <th>Version</th>
                            <th></th>
                            <th class="center">Mark Reviewed</th>
                            <th class="center">Preview</th>
                            <th class="center">View</th>
                        </tr>
                        <tbody class="tabular">
                            <?php
                            foreach ($lister->list as $page) {
                                $p = new Page();
                                $p->get($page->draft_for_page_id);
                                $version = $page->id;
                                $page_title = $page->title;
                                if (strlen($page_title) > 40) {
                                	$page_title = substr($page_title, 0, 40)."&hellip;";
                                }

                                $updated_datetime = date_create_from_format("Y-m-d H:i:s", $page->updated);

                                $page_id = $page->draft_for_page_id;
                                $page_version_id = $page->id;
                                $include_mark_reviewed_action = true;
                                $text = "submitted for review";
                                include("table_version_row.php");
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </fieldset>
            <?php
        }

        $lister = Listing::newInstance()
            ->onlyPublished(false)
            ->setLimit(10)
            ->setOrder([
                " `pages`.`updated` DESC "
            ])
            ->run();

        $lister->getListing();

        if (!empty($lister->list)) {
            ?>
            <fieldset id="latest_versions_made_current" class="row">
                <h3>
                    <a class="show dashboardFieldsetToggle el">
                        Latest Versions Made Current
                    <i class="fa fa-caret-down dashboardFieldsetToggleArrow"></i>
                    </a>
                </h3>
                <div class="dashboardSection">
                    <table class="manage-items pageVersions">
                        <tbody class="tabular">
                            <?php
                            foreach ($lister->list as $page) {
                                if (!empty($page->versions)) {
                                    $parent_versions = explode(" ", $page->versions);
                                    $current_version_was_created_from_version = 0;
                                    if (!empty($parent_versions)) {
                                        $current_version_was_created_from_version = $parent_versions[(count($parent_versions)-1)];
                                    }
                                }
                                if (!empty($current_version_was_created_from_version)) {
                                    $version = $current_version_was_created_from_version;
                                } else {
                                    $version = "";
                                }

                                $page_title = $page->title;
                                if (strlen($page->title) > 40) {
                                	$page_title = substr($page->title, 0, 40)."&hellip;";
                                }

                                $updated_datetime = date_create_from_format("Y-m-d H:i:s", $page->updated);

                                $page_id = $page->id;
                                $page_version_id = "";
                                $text = "made current";
                                include("table_version_row.php");
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </fieldset>
            <?php
        }
    }

    if (defined("CMS_PANEL_QUICK_ACCESS") && CMS_PANEL_QUICK_ACCESS == true) {
        $content_manager = new ContentManager();

        $lister = Listing::newInstance()
            ->setFilter([
                " `pages`.`listing_container` = 1 "
            ])
            ->run();

        $lister->getListing();

        if (!empty($lister->list)) {
            ?>
            <fieldset id="quick_access" class="row">
                <h3>
                    <a class="show dashboardFieldsetToggle el">
                        Quick Access
                    <i class="fa fa-caret-down dashboardFieldsetToggleArrow"></i>
                    </a>
                </h3>
                <div class="dashboardSection">
                    <table class="manage-items pagesWithChangesPendingReviewal">
                        <tbody class="tabular">
                                <tr>
                                    <td class="">
                                        <a
                                            href="?page=<?=$content_manager->getFrontPageId()?>"
                                            class="viewVersion"
                                            data-page-id="<?=$content_manager->getFrontPageId()?>"
                                            data-history-id=""
                                            title="View version"
                                        >
                                            Frontpage
                                        </a>
                                    </td>
                                </tr>
                            <?php
                            foreach ($lister->list as $page) {
                                ?><tr>
                                    <td class="">
                                        <a
                                            href="?page=<?=$page->id?>#tab=2"
                                            class="anchorClickLoadPage"
                                            data-page-id="<?=$page->id?>"
                                            data-history-id=""
                                            title="View version"
                                        >
                                            Manage <?=clean_page($page->title)?>
                                        </a>
                                    </td>
                                </tr>
                                <?php
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </fieldset>
            <?php
        }

        if (defined("PAGE_MANAGER") && PAGE_MANAGER === true) {
            ?>
            <fieldset id="page_order_manager" class="row">
                <h3>
                    <a class="show el dashboardFieldsetToggle">
                        Page Order Manager
                    <i class="fa fa-caret-down dashboardFieldsetToggleArrow"></i>
                    </a>
                </h3>
                <div class="row dashboardSection">
                    <p>You can reorder pages as well as move to up and/or down levels here. Pages that do not have a
                    ordering icon next to them are blocked for functional or SEO reasons. Remember, reordering
                    established pages up and/or down levels results in them changing their URLs thus potentially
                    affecting that page rankings in search engines.</p>
                    <div id="dashboarPageOrderManager">
                    <?php

                    $site_tree = CMSNav::siteTree(
                        0,
                        PHP_INT_MAX,
                        [
                            'check_innav'       => false,
                            'check_published'   => false,
                            'buttons'           => false
                        ]
                    );

                    echo $twig->render(
                        "/admin/dashboard_site_tree.twig",
                        array(
                            'tree' => $site_tree,
                            'options' => [],
                            'first_container_class' => 'dashboardSiteTree',
                            'limit' => PHP_INT_MAX,
                            'is_admin' => $_SESSION['content_manager']['is_mtcadmin']
                        )
                    );
                    ?>
                    </div>
                </div>
            </fieldset>
            <?php
        }
    }
    ?>
</div>
